%define oname pycurl
%define oversion %(echo %version | sed -e "s|\\.|_|g")

Name: python-module-%oname
Version: 7.43.0.6
Release: alt2

Summary: Python bindings to libcurl

License: LGPL
Group: Development/Python
Url: http://pycurl.io/

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://github.com/pycurl/pycurl/archive/REL_%oversion.tar.gz
Source: %oname-%version.tar

# revert python3 based improvement
# https://github.com/pycurl/pycurl/commit/9b8a7f97261cb91f4894a8afa0cf6221f546c361
Patch1: 9b8a7f97261cb91f4894a8afa0cf6221f546c361.patch

BuildRequires(pre): rpm-build-python
BuildRequires: libcurl-devel libssl-devel

BuildRequires(pre): libcurl
%define libcurlver %(rpm -q --qf '%%{VERSION}' libcurl)
Requires: libcurl >= %libcurlver

%description
This module provides the Python bindings to libcurl.

%prep
%setup -n %oname-%version
%patch1 -R -p1

%build
%add_optflags -fno-strict-aliasing

%__python setup.py docstrings
%python_build_debug

%install
%python_install

%files
%python_sitelibdir/*
%_docdir/%oname/


%changelog
