%define _unpackaged_files_terminate_build 1
%define modulename pymysql
%def_with python3
Name: python-module-%modulename
Version: 0.9.3
Release: alt2

%setup_python_module %modulename

Summary: This pure Python MySQL client provides a DB-API to a MySQL database.
License: MIT
Group: Development/Python

Url: http://code.google.com/p/pymysql/
BuildArch: noarch

# https://github.com/PyMySQL/PyMySQL.git
Source0: %name-%{version}.tar

# Based on https://github.com/PyMySQL/PyMySQL/commit/521e40050cb386a499f68f483fefd144c493053c
# See more https://github.com/advisories/GHSA-v9hf-5j83-6xpp
Patch: fix_CVE-2024-36039.patch

%if_with python3
BuildRequires(pre): rpm-build-python3 python3-module-setuptools
%endif
BuildRequires: python-module-setuptools

%description
This pure Python MySQL client provides a DB-API to a MySQL database by
talking directly to the server via the binary client/server protocol.

%package -n python3-module-%modulename
Summary: This pure Python MySQL client provides a DB-API to a MySQL database
Group: Development/Python3

%description -n python3-module-%modulename
This pure Python MySQL client provides a DB-API to a MySQL database by
talking directly to the server via the binary client/server protocol.

%prep
%setup
%patch -p1

%if_with python3
cp -fR . ../python3
%endif

%build
%python_build

%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif

%files
%doc CHANGELOG example.py *.rst
%python_sitelibdir/%modulename/
%python_sitelibdir/*.egg-info

%if_with python3
%files -n python3-module-%modulename
%doc CHANGELOG example.py *.rst
%python3_sitelibdir/%modulename/
%python3_sitelibdir/*.egg-info
%endif

%changelog
