%define oname pyodbc

%def_with check

Name:    python-module-%oname
Version: 4.0.35
Release: alt1

Summary: Python ODBC bridge
License: MIT-0
Group:   Development/Python
URL:     https://pypi.org/project/pyodbc/
VCS:     https://github.com/mkleehammer/pyodbc

Source: %name-%version.tar
Patch: odbc-4.0.35-alt-fix-pyodbc.pyi-location.patch

BuildRequires(pre): rpm-build-python
BuildRequires: gcc-c++
BuildRequires: libunixODBC-devel
%if_with check
BuildRequires: sqliteodbc
%endif

Requires: python-modules

%description
pyodbc is an open source Python module that makes accessing ODBC databases
simple. It implements the DB API 2.0 specification but is packed with even
more Pythonic convenience.

%prep
%setup
%patch -p0

echo 'Version: %{version}' > PKG-INFO

%build
%python_build

%install
%python_install

%check
export PYTHONPATH=%buildroot%python_sitelibdir
python2 tests2/sqlitetests.py -v "Driver=SQLITE3;Database=sqlite.db"

%files
%doc *.md *.txt
%python_sitelibdir/*.so
%python_sitelibdir/*.pyi
%python_sitelibdir/%oname-%version-*.egg-info

%changelog
