%define oname pytest-services
Name: python-module-%oname
Version: 2.0.1
Release: alt1
Summary: Services plugin for pytest testing framework
License: MIT
Group: Development/Python
BuildArch: noarch
Url: https://pypi.python.org/pypi/pytest-services/
# https://github.com/pytest-dev/pytest-services.git
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-html5lib python3-module-mysqlclient python3-module-pbr python3-module-pylibmc
BuildRequires: python3-module-pytest-cov python3-module-tox python3-module-unittest2
BuildRequires: python3-tools-pep8

%py_provides pytest_services
%py_requires requests psutil subprocess32
# we have several versions of Django
# so, we cannot rely on auto-requires
%filter_from_requires /^python2\.7(django\(\..*\)\?)/d
%filter_from_requires /^python3(django\(\..*\)\?)/d


%description
The plugin provides a set of fixtures and utility functions to start
service processes for your tests with pytest.

%package -n python3-module-%oname
Summary: Services plugin for pytest testing framework
Group: Development/Python
%py3_provides pytest_services
%py3_requires requests psutil

%description -n python3-module-%oname
The plugin provides a set of fixtures and utility functions to start
service processes for your tests with pytest.

%prep
%setup

%build
%python3_build_debug

%install
%python3_install

%check
py.test3 -vv --fixtures tests

%files -n python3-module-%oname
%doc *.rst docs/*.rst docs/api
%python3_sitelibdir/*

%changelog
