%define _unpackaged_files_terminate_build 1
%define pkgname requests

%def_disable check

Name:           python-module-requests
Version:        2.23.0
Release:        alt1
Summary:        HTTP library, written in Python, for human beings
Group:          Development/Python

License:        Apache-2.0
URL:            https://pypi.io/project/requests
Source0:        %pkgname-%version.tar
# Explicitly use the system certificates in ca-certificates.
# https://bugzilla.redhat.com/show_bug.cgi?id=904614
Patch0:         patch-requests-certs.py-to-use-the-system-CA-bundle.patch

# https://bugzilla.redhat.com/show_bug.cgi?id=1450608
Patch2:         Remove-tests-that-use-the-tarpit.patch

# Use 127.0.0.1 not localhost for socket.bind() in the Server test
# class, to fix tests in Koji's no-network environment
# This probably isn't really upstreamable, because I guess localhost
# could technically be IPv6 or something, and our no-network env is
# a pretty odd one so this is a niche requirement.
Patch3:         requests-2.12.4-tests_nonet.patch

# https://bugzilla.redhat.com/show_bug.cgi?id=1567862
Patch4:         Don-t-inject-pyopenssl-into-urllib3.patch

# https://bugzilla.redhat.com/show_bug.cgi?id=1653223
Patch5:         requests-2.20.0-no-py2-httpbin.patch

BuildArch:      noarch

%setup_python_module requests

BuildRequires: python-module-chardet
BuildRequires: python-module-setuptools
BuildRequires: python-module-urllib3
%{?_enable_check:BuildRequires: python-module-httpbin}

%py_requires json

%description
Most existing Python modules for sending HTTP requests are extremely verbose and
cumbersome. Python's built-in urllib2 module provides most of the HTTP
capabilities you should need, but the API is thoroughly broken. This library is
designed to make HTTP requests easy for developers.

%prep
%setup -n requests-%version

%patch0 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1

# Unbundle the certificate bundle from mozilla.
rm -rf requests/cacert.pem


%build
%python_build

%install
%python_install

%files
%doc AUTHORS.rst HISTORY.md README.md
%python_sitelibdir/*

%changelog
