%define  oname MaxMindDB
%define  fname maxminddb

Name:    python3-module-%oname
Version: 2.0.3
Release: alt1

Summary: Python MaxMind DB reader extension

License: Apache-2.0
Group:   Development/Python3
URL:     https://github.com/maxmind/MaxMind-DB-Reader-python

Packager: Grigory Ustinov <grenka@altlinux.org>

BuildRequires(pre): rpm-build-python3

BuildRequires: libmaxminddb-devel
BuildRequires: python3-module-sphinx

Source:  %oname-%version.tar

%description
This is a Python module for reading MaxMind DB files.  The module includes both
a pure Python reader and an optional C extension. MaxMind DB is a binary file
format that stores data indexed by IP address subnets (IPv4 or IPv6).

%package doc
Summary: Documentation for %oname
Group:   Development/Documentation

%description doc
This package provides the documentation for %oname.

%package pickles
Summary: Pickles for %oname
Group: Development/Python3

%description pickles
This package contains pickles for %oname.

%prep
%setup -n %oname-%version

%build
%python3_build

%make SPHINXBUILD="sphinx-build-3" -C docs man
%make SPHINXBUILD="sphinx-build-3" -C docs html
%make SPHINXBUILD="sphinx-build-3" -C docs pickle

%install
%python3_install

install -d %buildroot%_man1dir
cp -fR docs/_build/man/* %buildroot%_man1dir

install -d %buildroot%python3_sitelibdir/%fname
cp -fR docs/_build/pickle %buildroot%python3_sitelibdir/%fname/


%files
%doc README.rst
%python3_sitelibdir/%fname
%python3_sitelibdir/*.egg-info
%_man1dir/*
%exclude %python3_sitelibdir/%fname/pickle

%files doc
%doc LICENSE docs/_build/html

%files pickles
%python3_sitelibdir/%fname/pickle

%changelog
