%define oname RDFAlchemy

Name: python3-module-%oname
Version: 0.2.9
Release: alt3
Epoch: 1

Summary: rdflib wrapper for Python
License: BSD
Group: Development/Python3
Url: http://pypi.python.org/pypi/RDFAlchemy/
BuildArch: noarch

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-sphinx python-tools-2to3 python3-module-setuptools

%py3_provides %oname
%py3_requires paste.script


%description
RDFAlchemy is an abstraction layer, allowing python developers to use
familiar dot notation to access and update an rdf triplestore.

%prep
%setup

sed -i 's|@VERSION@|%version|' rdfalchemy/__init__.py

for i in $(find . -name '.*'); do
    if [ "$i" != "." ]; then
        rm -fR $i
    fi
done

%build
find -type f -name '*.py' -exec sed -i 's|%_bindir/env python|%_bindir/python3|' -- '{}' +
find -type f -name '*.py' -exec 2to3 -w '{}' +

for i in rdfalchemy/sparql/sesame2.py \
    rdfalchemy/sparql/parsers.py
do
    sed -i 's|import simplejson|import json as simplejson|' $i
done

%python3_build

%install
%python3_install

%files
%doc LICENSE README
%_bindir/sparql
%python3_sitelibdir/*


%changelog
