Name: python3-module-aiohttp
Version: 3.9.5
Release: alt1

Summary: http client/server for asyncio
License: Apache-2.0
Group: Development/Python
Url: https://github.com/aio-libs/aiohttp

Source0: %name-%version-%release.tar
Source1: llhttp.tar

BuildRequires(pre): rpm-build-pyproject
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)
BuildRequires: python3(cython)
BuildRequires: python3(multidict)

BuildRequires: python3(pytest)
BuildRequires: python3(pytest-cov)
BuildRequires: python3(pytest-mock)
BuildRequires: python3(attr)
BuildRequires: python3(yarl)
BuildRequires: python3(aiosignal)
BuildRequires: python3(gunicorn)
BuildRequires: python3(re_assert)
BuildRequires: python3(freezegun)
BuildRequires: python3(brotli)
BuildRequires: python3(brotlicffi)

# helpers.py uses async_timeout instead of asyncio if Python < 3.11
# AutoReq can't find this dependency due to nested import
%if "%(rpmvercmp %_python3_version 3.11)" < "0"
BuildRequires: python3(async_timeout)
Requires: python3(async_timeout)
%endif

%package tests
Summary: Tests for aiohttp
Group: Development/Python
Requires: python3-module-aiohttp = %EVR

%description
http client/server for asyncio (PEP-3156).

%description tests
http client/server for asyncio (PEP-3156).
This package contains tests for aiohttp

%prep
%setup -a1
# gen.py expects to find .git in project root, cheat a bit
sed -i 's,".git",".gitmodules",' tools/gen.py
# use system cython
sed -i '/^cythonize:/ s,.install-cython,,' Makefile
find tools -type f -name \*.py | xargs sed -ri '/env python$/ s,$,3,'

%build
make cythonize
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest -m 'not dev_mode and not internal' --ignore=tests/autobahn \
	--ignore=tests/test_proxy_functional.py tests ||:

%files
%doc *.txt *.rst examples
%python3_sitelibdir/aiohttp
%python3_sitelibdir/aiohttp-%version.dist-info
%exclude %python3_sitelibdir/aiohttp/*test*
%exclude %python3_sitelibdir/aiohttp/*/*test*

%files tests
%python3_sitelibdir/aiohttp/*test*
%python3_sitelibdir/aiohttp/*/*test*

%changelog
