# BEGIN SourceDeps(oneline):
BuildRequires: python3(sqlalchemy)
# END SourceDeps(oneline)
%define oname aiopg

%def_with python3
%def_without docs

Name: python3-module-%oname
Version: 1.2.1
Release: alt1
Summary: aiopg is a library for accessing a PostgreSQL database from the asyncio
License: BSD
Group: Development/Python3
Url: https://pypi.python.org/pypi/aiopg/

BuildArch: noarch

# https://github.com/aio-libs/aiopg.git
Source: %name-%version.tar
Patch1: %name-%version-alt.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-psycopg2 python3-module-async-timeout

BuildRequires(pre): rpm-macros-sphinx3
BuildRequires: python3-module-sphinx-devel python3-module-sphinxcontrib-asyncio

%py3_provides %oname
%py3_requires asyncio psycopg2 sqlalchemy

%description
aiopg is a library for accessing a PostgreSQL database from the asyncio
(PEP-3156/tulip) framework. It wraps asynchronous features of the
Psycopg database driver.

%prep
%setup
%patch1 -p1

%if_with docs
%prepare_sphinx3 .
ln -s ../objects.inv docs/
%endif

%build
%python3_build

%install
%python3_install

%if_with docs
%make -C docs html SPHINXBUILD=sphinx-build-3
%endif

rm -f requirements.txt

%check
python3 setup.py test

%files
%doc *.txt *.rst examples
%if_with docs
%doc docs/_build/html
%endif
%python3_sitelibdir/*

%changelog
