%define _unpackaged_files_terminate_build 1

%define oname argh
%def_with check

Name: python3-module-%oname
Version: 0.26.2
Release: alt2
Summary: An unobtrusive argparse wrapper with natural syntax
License: LGPLv3
Group: Development/Python3
Url: https://pypi.org/project/argh/

# https://github.com/neithere/argh.git
Source: %name-%version.tar
Patch0: %name-%version-alt.patch

BuildArch: noarch

BuildRequires(pre): rpm-build-python3

%if_with check
BuildRequires: python3(mock)
BuildRequires: python3(tox)
%endif

%description
An argparse wrapper that doesn't make you say "argh" each time you deal
with it.

http://argh.rtfd.org

%prep
%setup
%autopatch -p1

%build
%python3_build_debug

%install
%python3_install

%check
cat > tox.ini <<EOF
[testenv]
commands =
    {envpython} -m pytest {posargs:-vra}
EOF
export PIP_NO_INDEX=YES
export TOXENV=py3
tox.py3 --sitepackages -vvr

%files
%doc AUTHORS CHANGES *.rst
%python3_sitelibdir/*

%changelog
