%define _unpackaged_files_terminate_build 1

%define oname boto

Summary: A simple lightweight interface to Amazon Web Services
Name: python3-module-%oname
Version: 2.49.0
Release: alt2
License: MIT
Group: Development/Python3
Url: https://github.com/boto/boto

BuildArch: noarch

# https://github.com/boto/boto.git
Source: %name-%version.tar
Patch1: python-boto.vendored.six-remove.patch
Patch2: boto-python3.8-compat.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-nose
BuildRequires: python3-module-mock
BuildRequires: python3-module-httpretty
BuildRequires: python3-module-requests

%add_findreq_skiplist %python3_sitelibdir/%oname/mashups/order.py
%add_python3_req_skip Queue StringIO httplib urlparse

#Conflicts: python-module-boto
#Obsoletes: python-module-boto

%description
Boto is a Python package that provides interfaces to Amazon Web Services.
It supports S3 (Simple Storage Service), SQS (Simple Queue Service) via
the REST API's provided by those services and EC2 (Elastic Compute Cloud)
via the Query API. The goal of boto is to provide a very simple, easy to
use, lightweight wrapper around the Amazon services.

%prep
%setup
%patch1 -p1
%patch2 -p1

%build
%python3_build

%install
%python3_install

rm -fv %buildroot/usr/bin/*

%check
%{__python3} tests/test.py default

%files
%doc README.rst
%if 0
%{_bindir}/asadmin
%{_bindir}/bundle_image
%{_bindir}/cfadmin
%{_bindir}/cq
%{_bindir}/cwutil
%{_bindir}/dynamodb_dump
%{_bindir}/dynamodb_load
%{_bindir}/elbadmin
%{_bindir}/fetch_file
%{_bindir}/glacier
%{_bindir}/instance_events
%{_bindir}/kill_instance
%{_bindir}/launch_instance
%{_bindir}/list_instances
%{_bindir}/lss3
%{_bindir}/mturk
%{_bindir}/pyami_sendmail
%{_bindir}/route53
%{_bindir}/s3put
%{_bindir}/sdbadmin
%{_bindir}/taskadmin
%endif
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version-py*.egg-info

%changelog
