%def_with docs
%def_enable check

%define _unpackaged_files_terminate_build 1
%define oname cmd2

Name: python3-module-%oname
Version: 2.1.2
Release: alt1

Summary: A toolkit for simple interactive command-line applications

License: MIT
Group: Development/Python3
Url: https://pypi.org/project/cmd2/

# https://github.com/python-cmd2/cmd2
Source0: %oname-%version.tar.gz
Source1: cmd2.watch

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
Buildrequires: python3-module-setuptools_scm

%if_with docs
BuildRequires(pre): rpm-macros-sphinx3
BuildRequires: python3-module-sphinx
Buildrequires: python3-module-sphinx_rtd_theme
BuildRequires: python3-module-wcwidth
BuildRequires: python3-module-attrs
Buildrequires: python3-module-colorama
BuildRequires: python3-module-pyperclip
%endif

%if_enabled check
BuildRequires: pytest3
BuildRequires: python3-module-pytest-mock
BuildRequires: python3-module-pytest-cov
%endif

%description
cmd2, a toolkit for simple interactive command-line applications. A
drop-in enhancement adding features to the Python Standard Library's cmd
module.

%package docs
Summary: Documentation and examples for cmd2
Group: Development/Documentation

%description docs
cmd2, a toolkit for simple interactive command-line applications. A
drop-in enhancement adding features to the Python Standard Library's cmd
module.

This package contains documentation and examples for cmd2.

%package pickles
Summary: Pickles for cmd2
Group: Development/Python3

%description pickles
cmd2, a toolkit for simple interactive command-line applications. A
drop-in enhancement adding features to the Python Standard Library's cmd
module.

This package contains pickles for cmd2.

%prep
%setup -n %oname-%version

%if_with docs
%prepare_sphinx3 .
ln -s ../objects.inv docs/
%endif

%build
%python3_build_debug

%if_with docs
# temporary install to avoid circular dependency
%__python3 setup.py install --skip-build --root=_build --force
export PYTHONPATH=$PWD/_build/%python3_sitelibdir

sphinx-build-3 -b html docs build/html
sphinx-build-3 -b pickle docs build/pickle

# remove the sphinx-build leftovers
rm -rf build/html/.{doctrees,buildinfo}
rm -rf build/pickles/.{doctrees,buildinfo}
%endif

%install
%python3_install

%if_with docs
install -d %buildroot%python3_sitelibdir/%oname
cp -fR build/pickle %buildroot%python3_sitelibdir/%oname/
%endif

%check
export PYTHONPATH=$PWD/_build/%python3_sitelibdir
pytest3

%files
%doc LICENSE PKG-INFO *.md
%python3_sitelibdir/%oname
%python3_sitelibdir/*.egg-info
%if_with docs
%exclude %python3_sitelibdir/%oname/pickle

%files docs
%doc build/html docs/examples

%files pickles
%dir %python3_sitelibdir/%oname
%python3_sitelibdir/%oname/pickle
%endif

%changelog
