%define oname codepy

Name: python3-module-%oname
Version: 2013.1.2
Release: alt2

Summary: C metaprogramming toolkit for Python
License: MIT
Group: Development/Python3
Url: http://documen.tician.de/codepy/
# http://git.tiker.net/trees/codepy.git
BuildArch: noarch

Source: %oname-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python-tools-2to3 python3-module-sphinx

%py3_requires decorator


%description
CodePy is a C metaprogramming toolkit for Python. It handles two aspects
of metaprogramming:

* Generating C source code.

* Compiling this source code and dynamically loading it into the Python
interpreter.

Both capabilities are meant to be used together, but also work on their
own. In particular, the code generation facilities work well in
conjunction with PyCuda. Dynamic compilation and linking are so far only
supported in Linux with the GNU toolchain.

%package pickles
Summary: Pickles for CodePy
Group: Development/Python3

%description pickles
CodePy is a C metaprogramming toolkit for Python. It handles two aspects
of metaprogramming:

* Generating C source code.

* Compiling this source code and dynamically loading it into the Python
interpreter.

This package contains pickles for CodePy.

%prep
%setup

## py2 -> py3
find -type f -name '*.py' -exec 2to3 -w '{}' +

sed -i 's|sphinx-build|sphinx-build-3|' doc/Makefile

sed -i 's|#!/usr/bin/env python|#!/usr/bin/env python3|' \
    $(find ./ -name '*.py')
##

%build
%python3_build_debug

%make -C doc html
%make -C doc pickle

%install
%python3_install

cp -fR doc/build/pickle \
    %buildroot%python3_sitelibdir/%oname/

%files
%doc *.rst doc/build/html
%python3_sitelibdir/*
%exclude %python3_sitelibdir/%oname/pickle

%files pickles
%python3_sitelibdir/%oname/pickle


%changelog
