%define sname couchdb

%def_disable check

Name: python3-module-%sname
Version: 1.2
Release: alt1

Summary: Python library for working with CouchDB. 
License: BSD
Group: Development/Python3
URL: http://code.google.com/p/couchdb-python/
BuildArch: noarch

# https://github.com/djc/couchdb-python.git
Source0: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-pytest python3-module-sphinx
BuildRequires: python-tools-2to3


%description
A Python library for CouchDB. It provides a convenient high level
interface for the CouchDB server.

%package tests
Summary: Tests for %sname
Group: Development/Python3
Requires: %name = %EVR

%description tests
A Python library for CouchDB. It provides a convenient high level
interface for the CouchDB server.

This package contains tests for %sname.

%prep
%setup

find -type f -name '*.py' -exec 2to3 -w -n '{}' +

sed -i 's|sphinx-build|sphinx-build-3|' doc/Makefile

sed -i 's|#!/usr/bin/env python|#!/usr/bin/env python3|' \
    $(find ./ -name '*.py')

%build
%python3_build

%install
%python3_install

%make -C doc html

%check
%__python3 setup.py test

%files
%doc *.rst doc/build/html
%_bindir/*
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/tests

%files tests
%python3_sitelibdir/*/tests


%changelog
