%define modname dateparser
#module 'logging' has no attribute 'config'
%def_disable check

Name: python3-module-%modname
Version: 1.0.0
Release: alt1

Summary: Python parser for human readable dates 
License: BSD-3-Clause
Group: Development/Python3
Url: https://pypi.python.org/pypi/dateparser

#VCS: https://github.com/scrapinghub/dateparser.git
Source: https://github.com/scrapinghub/dateparser/archive/v%version/%modname-%version.tar.gz
BuildArch: noarch

#grep calendars setup.py 
#'calendars': ['convertdate', 'umalqurra', 'jdatetime', 'ruamel.yaml'],

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-setuptools
BuildRequires: python3-module-nose python3-module-mock
BuildRequires: python3-module-parameterized python3-module-wheel
BuildRequires: python3-module-dateutil python3-module-tzlocal python3-module-regex
BuildRequires: python3-module-sphinx-devel python3-module-sphinx_rtd_theme
%{?_enable_check:BuildRequires: python3-module-flake8 python3-module-pytest
BuildRequires: python3-module-pytest-cov python3-module-parameterized
BuildRequires: python3-module-orderedset python3-module-convertdate
BuildRequires: python3-module-ruamel-yaml python3-module-umalqurra
BuildRequires: python3-module-hijri-converter}

%description
Date parsing library designed to parse dates from HTML pages.

%package pickles
Summary: Pickles for %modname
Group: Development/Python3

%description pickles
Date parsing library designed to parse dates from HTML pages.

This package contains pickles for %modname.

%package docs
Summary: Documentation for %modname
Group: Development/Documentation
BuildArch: noarch

%description docs
Date parsing library designed to parse dates from HTML pages.

This package contains documentation for %modname.

%prep
%setup -n %modname-%version

%prepare_sphinx3 .
ln -s ../objects.inv docs/

%build
%python3_build_debug

%install
%python3_install

export PYTHONPATH=$PWD
%make -C docs pickle html SPHINXBUILD=sphinx-build-3

cp -fR docs/_build/pickle %buildroot%python3_sitelibdir/%modname/

%check
%__python3 setup.py test

%files
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/pickle
%doc *.rst

%files pickles
%python3_sitelibdir/*/pickle

%files docs
%doc docs/_build/html/*


%changelog
