%define oname designateclient
%def_without check
%def_with docs

Name: python3-module-%oname
Version: 5.2.0
Release: alt0.p10

Summary: OpenStack DNS-as-a-Service - Client

License: Apache-2.0
Group: Development/Python3
Url: https://pypi.org/project/python-designateclient

Source: %oname-%version.tar
Source1: %oname.watch

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: python3-module-cliff >= 2.8.0
BuildRequires: python3-module-jsonschema >= 3.2.0
BuildRequires: python3-module-osc-lib >= 1.8.0
BuildRequires: python3-module-oslo.serialization >= 2.18.0
BuildRequires: python3-module-oslo.utils >= 3.33.0
BuildRequires: python3-module-pbr >= 2.0.0
BuildRequires: python3-module-keystoneauth1 >= 3.4.0
BuildRequires: python3-module-requests >= 2.14.2
BuildRequires: python3-module-stevedore >= 1.20.0
BuildRequires: python3-module-debtcollector >= 1.2.0

%if_with check
BuildRequires: python3-module-hacking >= 3.0.1 python3-module-hacking < 3.1.0
BuildRequires: python3-module-coverage >= 4.0
BuildRequires: python3-module-oslo.config >= 5.2.0
BuildRequires: python3-module-oslotest >= 3.2.0
BuildRequires: python3-module-subunit >= 1.0.0
BuildRequires: python3-module-requests-mock >= 1.2.0
BuildRequires: python3-module-stestr >= 2.0.0
BuildRequires: python3-module-reno >= 3.1.0
BuildRequires: python3-module-tempest >= 25.0.0
%endif

%if_with docs
BuildRequires: python3-module-sphinx
BuildRequires: python3-module-openstackdocstheme >= 1.18.1
BuildRequires: python3-module-sphinxcontrib-apidoc
%endif

Requires: python3-module-cliff >= 4.1.0 python3-module-cliff <= 4.2.0
Requires: python3-module-jsonschema >= 3.2.0
Requires: python3-module-osc-lib = 2.7.0
Requires: python3-module-oslo.serialization >= 5.1.0 python3-module-oslo.serialization <= 5.1.1
Requires: python3-module-oslo.utils = 6.1.0
Requires: python3-module-pbr >= 2.0.0
Requires: python3-module-keystoneauth1 >= 5.1.0 python3-module-keystoneauth1 <= 5.1.2
Requires: python3-module-requests >= 2.14.2
Requires: python3-module-stevedore >= 4.1.0 python3-module-stevedore <= 5.0.0
Requires: python3-module-debtcollector >= 1.2.0

%description
There's a Python API (the designateclient module), and a command-line tool
(designate).

%if_with check
%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
This package contains tests for %oname.
%endif

%if_with docs
%package doc
Summary: Documentation for %oname
Group: Development/Documentation

%description doc
This package contains documentation for %oname.
%endif

%prep
%setup -n %oname-%version

# Remove bundled egg-info
rm -rfv *.egg-info

%build
%pyproject_build

%if_with docs
export PYTHONPATH="$PWD"
# generate html docs
sphinx-build-3 doc/source html
# generate man page
sphinx-build-3 -b man doc/source man
# remove the sphinx-build leftovers
rm -rf html/.{doctrees,buildinfo}
%endif

%install
%pyproject_install

%if_with docs
# install man page
install -pDm 644 man/python-%oname.1 %buildroot%_man1dir/%oname.1
%endif

%if_with check
%check
%__python3 -m stestr run
%endif

%files
%doc LICENSE AUTHORS ChangeLog *.rst
%python3_sitelibdir/%oname
%python3_sitelibdir/python_designateclient-%version.dist-info
%exclude %python3_sitelibdir/%oname/tests
%exclude %python3_sitelibdir/%oname/functionaltests

%if_with check
%files tests
%python3_sitelibdir/%oname/tests
%python3_sitelibdir/%oname/functionaltests
%endif

%if_with docs
%files doc
%doc LICENSE *.rst html
%_man1dir/%oname.1.xz
%endif

%changelog
