%define oname django-debreach
%define dirname debreach
%define distinfo django_debreach

Name: python3-module-%oname
Version: 2.1.0
Release: alt1.p10

Summary: Extra mitigation against the BREACH attack for Django projects

Group: Development/Python3
License: BSD-2-Clause
Url: https://github.com/lpomfrey/django-debreach

Source: %oname-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: python3-module-django >= 1.3

Requires: python3-module-django >= 1.3

%description
django-debreach provides additional protection to Django's built in CSRF
token masking by randomising the content length of each response.
This is achieved by adding a random string of between 12 and 25 characters
as a comment to the end of the HTML content. Note that this will only be
applied to responses with a content type of text/html.

%prep
%setup -n %oname-%version

# Remove bundled egg-info
rm -rf *.egg-info

%build
export PBR_VERSION=%version
%pyproject_build

%install
%pyproject_install

%files
%doc LICENSE *.rst
%python3_sitelibdir/%dirname
%python3_sitelibdir/%distinfo-%version.dist-info

%changelog
