%define mname dogpile
%define oname %mname.cache

%def_with check

Name: python3-module-%oname
Version: 1.2.2
Release: alt0.1.p10

Summary: A caching front-end based on the Dogpile lock

License: MIT
Group: Development/Python3
Url: https://pypi.python.org/pypi/dogpile.cache/

# https://github.com/sqlalchemy/dogpile.cache
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3

%if_with check
BuildRequires: python3-module-pbr
BuildRequires: python3-module-tox
BuildRequires: python3-module-pytest
BuildRequires: python3-module-mako
BuildRequires: python3-module-decorator
BuildRequires: python3-module-stevedore
BuildRequires: python3-module-typing_extensions
%endif

Requires: python3-module-typing_extensions

Provides: python3-module-dogpile-cache = %EVR
Obsoletes: python3-module-dogpile-cache < %EVR
Provides: python3-module-dogpile-core = %EVR
Obsoletes: python3-module-dogpile-core < %EVR

%py3_provides %oname
%py3_provides %mname.core

%description
A caching API built around the concept of a "dogpile lock", which allows
continued access to an expiring data value while a single thread
generates a new value.

dogpile.cache builds on the dogpile.core locking system, which
implements the idea of "allow one creator to write while others read" in
the abstract. Overall, dogpile.cache is intended as a replacement to the
Beaker caching system, the internals of which are written by the same
author. All the ideas of Beaker which "work" are re-implemented in
dogpile.cache in a more efficient and succinct manner, and all the cruft
(Beaker's internals were first written in 2005) relegated to the trash
heap.

%prep
%setup

%build
%python3_build

%install
%python3_install

%if "%_libexecdir" != "%_libdir"
mv %buildroot%_libexecdir %buildroot%_libdir
%endif

%check
export PIP_NO_BUILD_ISOLATION=no
export PIP_NO_INDEX=YES
export TOXENV=py3
tox.py3 --sitepackages

%files
%doc *.rst
%python3_sitelibdir/%mname
%python3_sitelibdir/%oname-%version-py%_python3_version.egg-info

%changelog
