%define oname eventlet

%def_without check
%def_with docs

Name: python3-module-%oname
Version: 0.33.3
Release: alt2.p10

Summary: Highly concurrent networking library
License: MIT
Group: Development/Python3

Url: https://pypi.org/project/eventlet/

# Source-url: %__pypi_url %oname
Source: %name-%version.tar
Patch: remove-nose.patch
Patch1: eventlet-0.33.3-alt-drop-distutils.patch

BuildArch: noarch

BuildRequires(pre): rpm-build-intro >= 2.2.5
BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-macros-sphinx3
BuildRequires: python3-module-sphinx

BuildRequires: python3-module-urllib3

# generated by epm --restore --dry-run from eventlet/setup.py install_requires

%py3_use dns >= 1.15.0
%py3_use greenlet >= 0.3
%py3_use six >= 1.10.0

%if_with check
BuildRequires: python3(zmq)
BuildRequires: pytest3
%endif

%add_python3_req_skip stackless

# required by strange pylib.py:
%add_python3_req_skip py.magic

%description
Eventlet is a concurrent networking library for Python that allows you
to change how you run your code, not how you write it.

It uses epoll or libevent for highly scalable non-blocking I/O.
Coroutines ensure that the developer uses a blocking style of
programming that is similar to threading, but provide the benefits of
non-blocking I/O. The event dispatch is implicit, which means you can
easily use Eventlet from the Python interpreter, or as a small part of a
larger application.

%if_with docs
%package pickles
Summary: Pickles for Eventlet
Group: Development/Python

%description pickles
Eventlet is a concurrent networking library for Python that allows you
to change how you run your code, not how you write it.

It uses epoll or libevent for highly scalable non-blocking I/O.
Coroutines ensure that the developer uses a blocking style of
programming that is similar to threading, but provide the benefits of
non-blocking I/O. The event dispatch is implicit, which means you can
easily use Eventlet from the Python interpreter, or as a small part of a
larger application.

This package contains pickles for Eventlet.

%package docs
Summary: Documentation for Eventlet
Group: Development/Documentation
BuildArch: noarch

%description docs
Eventlet is a concurrent networking library for Python that allows you
to change how you run your code, not how you write it.

It uses epoll or libevent for highly scalable non-blocking I/O.
Coroutines ensure that the developer uses a blocking style of
programming that is similar to threading, but provide the benefits of
non-blocking I/O. The event dispatch is implicit, which means you can
easily use Eventlet from the Python interpreter, or as a small part of a
larger application.

This package contains documentation for Eventlet.
%endif

%prep
%setup
%patch -p1
%patch1 -p1

# requires thrift, python 2.7 only
rm -rv eventlet/zipkin

# remove obsoleted tsafe (ALT bug 45443)
rm -v eventlet/green/OpenSSL/tsafe.py

%if_with docs
%prepare_sphinx3 .
ln -s ../objects.inv doc/
%endif

%build
%python3_build

export PYTHONPATH=$(pwd)/build/lib
%if_with docs
%make -C doc html SPHINXBUILD=sphinx-build-3
%endif

%install
%python3_install
%python3_prune

%check
# raise timeouts
#grep -qsrF 'TEST_TIMEOUT =' || exit 1
#grep -srlF 'TEST_TIMEOUT =' | xargs \
#sed -i 's/TEST_TIMEOUT[[:space:]]*=[[:space:]]*[0-9]\+$/TEST_TIMEOUT = 20/g'
py.test3 -v -o norecursedirs="tests/*" -k "
	not BackdoorTest and \
	not test_server and \
	not test_dns_methods_are_green and \
	not test_noraise_dns_tcp and \
	not test_fork_after_monkey_patch and \
	not test_send_1k_req_rep and \
	not test_cpu_usage_after_bind and \
	not test_leakage_from_tracebacks and \
	not test_connect_ssl and \
	not test_ssl_sending_messages and \
	not test_wrap_ssl and \
	not ssl_test and \
	not wsgi_test and \
	not test_patcher_existing_locks_locked and \
	not test_017_ssl_zeroreturnerror and \
	not TestProxyResolver and \
	not TinyDNSTests"

%files
%doc AUTHORS NEWS README.rst
%python3_sitelibdir/eventlet-%version-py%_python3_version.egg-info/
%python3_sitelibdir/eventlet/

%if_with doc
%files docs
%doc examples doc/_build/html
%endif

%changelog
