%define _unpackaged_files_terminate_build 1

%define oname ffc

Name: python3-module-%oname
Epoch: 1
Version: 2019.1.0
Release: alt2
Summary: Compiler for finite element variational forms
Group: Development/Tools
License: LGPLv3+
URL: https://fenicsproject.org/

BuildArch: noarch

# https://bitbucket.org/fenics-project/ffc.git
Source: %name-%version.tar
# http://www.fenics.org/pub/documents/ffc/ffc-user-manual/ffc-user-manual.pdf
Source1: ffc-user-manual.pdf
Patch0: 0001-Add-compatibility-against-Pytest-6.0.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-setuptools
BuildRequires: libnumpy-py3-devel
BuildRequires: python3-module-fiat
BuildRequires: python3-module-ufl
# test dependencies
BuildRequires: python3-module-pytest
BuildRequires: cmake gcc-c++

Provides: %oname = %EVR
Obsoletes: %oname < %EVR

%add_python3_req_skip coffee.base coffee.plan coffee.visitors
%add_python3_req_skip tsfc.driver tsfc.kernel_interface.ufc

%description
FFC is a compiler for finite element variational forms. From a high-level
description of the form, it generates efficient low-level C++ code that
can be used to assemble the corresponding discrete operator (tensor). In
particular, a bilinear form may be assembled into a matrix and a linear
form may be assembled into a vector.

FFC may be used either from the command line (by invoking the 'ffc' command)
or as a Python module ('import ffc').

FFC is part of the FEniCS project (www.fenics.org) and functions as a
just-in-time (JIT) compiler for DOLFIN.

%package doc
Summary: User manual for FFC
Group: Development/Documentation
BuildArch: noarch
Requires: %name = %EVR

%description doc
FFC is a compiler for finite element variational forms. From a high-level
description of the form, it generates efficient low-level C++ code that
can be used to assemble the corresponding discrete operator (tensor). In
particular, a bilinear form may be assembled into a matrix and a linear
form may be assembled into a vector.

This package contains user manual for UFL (Unified Form Language).

%prep
%setup
%autopatch -p1

%build
%python3_build

%install
%python3_build_install --optimize=2

install -d %buildroot%_docdir/%name
install -p -m644 %SOURCE1 %buildroot%_docdir/%name

%check
# test_evaluate.py uses libs/ffc-factory, which is currently ignored
# test_elements.py uses dijitso
python3 -m pytest -v test/ --ignore=test/unit/ufc/finite_element/test_evaluate.py --ignore=test/unit/misc/test_elements.py

%files
%doc COPYING COPYING.LESSER LICENSE
%doc AUTHORS ChangeLog.* README.rst
%_bindir/*
%_man1dir/*
%python3_sitelibdir/*

%files doc
%_docdir/%name
%doc demo

%changelog
