%define _unpackaged_files_terminate_build 1
%define oname ghp-import

%def_with check

Name: python3-module-%oname
Version: 2.0.1
Release: alt1
Summary: Copy your docs directly to the gh-pages branch
License: Apache-2.0
Group: Development/Python3

Url: https://pypi.org/project/ghp-import

# https://github.com/davisp/ghp-import.git
Source0: %name-%version.tar
BuildArch: noarch

BuildRequires(pre): rpm-build-python3

%if_with check
# install_requires:
BuildRequires: python3(dateutil)

BuildRequires: python3(tox)
%endif

Provides: ghp-import.py3 = %EVR
Obsoletes: ghp-import.py3 < 0.5.5

# file conflict: /usr/bin/ghp-import
Conflicts: ghp-import

# PyPI name(dash, underscore)
%py3_provides %oname

Requires: git

%description
As part of gunicorn, Benoit Chesneau and I have been starting to look at
how to host documentation. There's the obvious method of using GitHub's
post-receive hook to trigger doc builds and rsync to a webserver, but we
ended up wanting to try out github's hosting to make the whole interface
a bit more robust.

%prep
%setup

%build
%python3_build

%install
%python3_install

%check
# upstream doesn't provide tests, at least, install it and run `--help`
cat > tox.ini <<EOF
[testenv]
usedevelop=True
commands =
    {envbindir}/ghp-import --help
EOF
export PIP_NO_INDEX=YES
export TOXENV=py3
tox.py3 --sitepackages -vvr -s false

%files
%doc LICENSE README.md
%_bindir/ghp-import
%python3_sitelibdir/*

%changelog
