%define _unpackaged_files_terminate_build 1
%define oname gmpy2

Name: python3-module-%oname
Version: 2.1.0
Release: alt1

Summary: GMP/MPIR, MPFR, and MPC interface

License: LGPL-3.0+
Group: Development/Python3
Url: http://code.google.com/p/gmpy/

# Source-url: https://pypi.python.org/packages/90/f4/9a2e384b325b69bc5827b9a6510a8fb4a51698c915c06a3f25a86458892a/%{oname}-%{version}.zip
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-macros-sphinx3
BuildRequires: python3-devel
BuildRequires: libmpc-devel
BuildRequires: python3-module-sphinx python3-module-sphinx-sphinx-build-symlink

%description
A C-coded Python extension module that wraps the GMP library to provide
to Python code fast multiprecision arithmetic (integer, rational, and
float), random number generation, advanced number-theoretical functions,
and more.

%package docs
Summary: Documentation and tests for GMPY
Group: Development/Documentation
BuildArch: noarch

%description docs
A C-coded Python extension module that wraps the GMP library to provide
to Python code fast multiprecision arithmetic (integer, rational, and
float), random number generation, advanced number-theoretical functions,
and more.

This package contains documentation and tests for GMPY.

%package pickles
Summary: Pickles for GMPY
Group: Development/Python

%description pickles
A C-coded Python extension module that wraps the GMP library to provide
to Python code fast multiprecision arithmetic (integer, rational, and
float), random number generation, advanced number-theoretical functions,
and more.

This package contains pickles for GMPY.

%prep
%setup

%prepare_sphinx3 .

%build
%add_optflags -fno-strict-aliasing
%python3_build_debug

%make -C docs html

%install
%python3_install

#install -d %buildroot%python_sitelibdir/%oname
#cp -fR docs/_build/pickle %buildroot%python_sitelibdir/%oname/

%check
export PYTHONPATH=%buildroot%python3_sitelibdir
python3 test/gmpy_test.py
python3 test/runtests.py

%files
%doc README
%python3_sitelibdir/*

%files docs
%doc docs/_build/html test*

%changelog
