%define _unpackaged_files_terminate_build 1
%define mname gssapi

%def_with check

Name: python3-module-%mname
Version: 1.6.12
Release: alt1

Summary: Python Bindings for GSSAPI (RFC 2743/2744 and extensions)
License: ISC
Group: Development/Python3
# Source-git: https://github.com/pythongssapi/python-gssapi
Url: https://pypi.python.org/pypi/gssapi

Source: %name-%version.tar
Patch: %name-%version-alt.patch

BuildRequires(pre): rpm-build-python3

BuildRequires: python3(Cython)
BuildRequires: libkrb5-devel >= 1.15

%if_with check
BuildRequires: python3(decorator)
BuildRequires: python3(future)
BuildRequires: python3(k5test)
BuildRequires: python3(nose)
BuildRequires: python3(parameterized)
BuildRequires: python3(six)
BuildRequires: python3(tox)
BuildRequires: krb5-kdc >= 1.15
%endif

Requires: libkrb5 >= 1.15

%description
A set of Python bindings to the GSSAPI C library providing both
a high-level pythonic interfaces and a low-level interfaces
which more closely matches RFC 2743.  Includes support for
RFC 2743, as well as multiple extensions.

%prep
%setup
%patch -p1

%build
%add_optflags -fno-strict-aliasing
%python3_build_debug

%install
%python3_install

%check
export PIP_NO_INDEX=YES
export TOXENV=py%{python_version_nodots python3}
tox.py3 --sitepackages -r -vv

%files
%doc LICENSE.txt README.rst
%python3_sitelibdir/%mname
%python3_sitelibdir/%mname-%version-*.egg-info

%exclude %python3_sitelibdir/%mname/tests/

%changelog
