%define oname heatclient
%def_without check
%def_without docs

Name: python3-module-%oname
Version: 3.2.0
Release: alt1.p10

Summary: OpenStack Orchestration API Client Library

License: Apache-2.0
Group: Development/Python3
Url: https://pypi.org/project/python-heatclient

Source: %oname-%version.tar
Source1: %oname.watch

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: python3-module-babel >= 2.3.4
BuildRequires: python3-module-pbr >= 2.0.0
BuildRequires: python3-module-cliff >= 2.8.0
BuildRequires: python3-module-iso8601 >= 0.1.11
BuildRequires: python3-module-osc-lib >= 1.14.0
BuildRequires: python3-module-prettytable >= 0.7.2
BuildRequires: python3-module-oslo.i18n >= 3.15.3
BuildRequires: python3-module-oslo.serialization >= 2.18.0
BuildRequires: python3-module-oslo.utils >= 3.33.0
BuildRequires: python3-module-keystoneauth1 >= 3.8.0
BuildRequires: python3-module-swiftclient >= 3.2.0
BuildRequires: python3-module-yaml >= 3.13
BuildRequires: python3-module-requests >= 2.14.2

%if_with check
BuildRequires: python3-module-hacking >= 3.0.1 python3-module-hacking < 3.1.0
BuildRequires: python3-module-coverage >= 4.0
BuildRequires: python3-module-fixtures >= 3.0.0
BuildRequires: python3-module-requests-mock >= 1.2.0
BuildRequires: python3-module-openstackclient >= 3.12.0
BuildRequires: python3-module-stestr >= 2.0.0
BuildRequires: python3-module-tempest >= 17.1.0
BuildRequires: python3-module-testscenarios >= 0.4
BuildRequires: python3-module-testtools >= 2.2.0
%endif

%if_with docs
BuildRequires: python3-module-openstackdocstheme >= 2.2.1
BuildRequires: python3-module-reno >= 3.1.0
BuildRequires: python3-module-sphinx >= 2.0.0
BuildRequires: python3-module-sphinxcontrib-httpdomain >= 1.3.0
%endif

Requires: python3-module-babel >= 2.3.4
Requires: python3-module-pbr >= 2.0.0
Requires: python3-module-cliff >= 2.8.0
Requires: python3-module-iso8601 >= 0.1.11
Requires: python3-module-osc-lib >= 1.14.0
Requires: python3-module-prettytable >= 0.7.2
Requires: python3-module-oslo.i18n >= 3.15.3
Requires: python3-module-oslo.serialization >= 2.18.0
Requires: python3-module-oslo.utils >= 3.33.0
Requires: python3-module-keystoneauth1 >= 3.8.0
Requires: python3-module-swiftclient >= 3.2.0
Requires: python3-module-yaml >= 3.13
Requires: python3-module-requests >= 2.14.2

%description
There's a Python API (the heatclient module), and a command-line script (heat).
Each implements 100 percent of the OpenStack Heat API.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
This package contains tests for %oname.

%if_with docs
%package doc
Summary: Documentation for %oname
Group: Development/Documentation

%description doc
This package contains documentation for %oname.
%endif

%prep
%setup -n %oname-%version

# Remove bundled egg-info
rm -rfv *.egg-info

%build
%pyproject_build

%if_with docs
export PYTHONPATH="$PWD"
# generate html docs
sphinx-build-3 doc/source html
# generate man page
sphinx-build-3 -b man doc/source man
# remove the sphinx-build leftovers
rm -rf html/.{doctrees,buildinfo}
%endif

%install
%pyproject_install

%if_with docs
# install man page
install -pDm 644 man/heat.1 %buildroot%_man1dir/%oname.1
%endif

# install bash completion
install -pDm 644 tools/heat.bash_completion \
  %buildroot%_sysconfdir/bash_completion.d/heat.bash_completion

%check
%__python3 -m stestr run

%files
%doc LICENSE AUTHORS ChangeLog *.rst
%_bindir/heat
%python3_sitelibdir/%oname
%python3_sitelibdir/python_heatclient-%version.dist-info
%_sysconfdir/bash_completion.d/heat.bash_completion
%exclude %python3_sitelibdir/%oname/tests

%files tests
%python3_sitelibdir/%oname/tests

%if_with docs
%files doc
%doc LICENSE *.rst html
%_man1dir/%oname.1.xz
%endif

%changelog
