%define _unpackaged_files_terminate_build 1
%define pypi_name httpbin

%def_with check

Name: python3-module-%pypi_name
Version: 0.10.2
Release: alt0.p10.1

Summary: HTTP Request and Response Service
License: ISC
Group: Development/Python3
Url: https://pypi.org/project/httpbin/
Vcs: https://github.com/psf/httpbin

BuildArch: noarch

Source0: %name-%version.tar
Source1: %pyproject_deps_config_name
Source2: setuptools-68.2.2-py3-none-any.whl
Patch0: %name-%version-alt.patch

%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-werkzeug
BuildRequires: python3-module-flask
BuildRequires: python3-module-brotlicffi
BuildRequires: python3-module-six
BuildRequires: python3-module-decorator
%pyproject_builddeps_metadata_extra test
%endif

%description
Testing an HTTP Library can become difficult sometimes. PostBin.org is
fantastic for testing POST requests, but not much else. This exists to
cover all kinds of HTTP scenarios. Additional endpoints are being
considered.

All endpoint responses are JSON-encoded.

%prep
%setup
%autopatch -p1
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%build
# build with bundled setuptools
mkdir dist
cp %SOURCE2 dist/
echo "$(basename '%SOURCE2')" > dist/.wheeltracker
%pyproject_run -- bash -s <<-'ENDUNITTEST'
# redefine __python3 to python3 instead of /usr/bin/python3 to point to virt one
%global __python3_orig %__python3
%define __python3 python3
%pyproject_build
%define __python3 %__python3_orig
ENDUNITTEST

%install
%pyproject_install

%check
%pyproject_run_pytest -vra

%files
%doc AUTHORS README.md LICENSE
%python3_sitelibdir/%pypi_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
