%define _unpackaged_files_terminate_build 1
%define pypi_name hypothesis
%define mod_name %pypi_name

%def_without check

Name: python3-module-%pypi_name
Version: 6.82.3
Release: alt1

Summary: A library for property based testing

License: MPL-2.0-no-copyleft-exception
Group: Development/Python3
Url: https://pypi.org/project/hypothesis/
VCS: https://github.com/HypothesisWorks/hypothesis

BuildArch: noarch

Source: %name-%version.tar
Source1: pytest.ini
Source2: %pyproject_deps_config_name
Source3: test.in
Patch0: %name-%version-alt.patch
%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%add_pyproject_deps_check_filter dpcontracts
%pyproject_builddeps_metadata_extra all
%pyproject_builddeps_check
# needed by pexpect
BuildRequires: /dev/pts
# filtered by default
BuildRequires: python3-module-black
# shipped in subpackage
BuildRequires: python3-module-numpy-testing
# not listed as tests' dependency
BuildRequires: python3-module-fakeredis
%endif
%add_python3_req_skip dpcontracts pandas

%description
Hypothesis is an advanced testing library for Python. It lets you write tests
which are parametrized by a source of examples, and then generates simple and
comprehensible examples that make your tests fail. This lets you find more bugs
in your code with less work.

%prep
%setup
cp %SOURCE1 ./
%autopatch -p1
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_pipreqfile %SOURCE3
%endif

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest -ra -nauto tests

%files
%doc README.rst
%_bindir/hypothesis
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/
%python3_sitelibdir/__pycache__/_hypothesis_pytestplugin.*
%python3_sitelibdir/_hypothesis_pytestplugin.py
%python3_sitelibdir/__pycache__/_hypothesis_ftz_detector.*
%python3_sitelibdir/_hypothesis_ftz_detector.py

%changelog
