%define oname igakit

Name: python3-module-%oname
Version: 0.1
Release: alt3

Summary: Toolkit for IsoGeometric Analysis (IGA)
License: BSD
Group: Development/Python3
Url: https://petiga-igakit.readthedocs.org/en/latest/

# hg clone https://bitbucket.org/dalcinl/igakit
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: libnumpy-py3-devel gcc-fortran
BuildRequires: python3-module-numpy


%description
igakit: Toolkit for IsoGeometric Analysis (IGA).

%prep
%setup

ln -s $(python3 -c 'import numpy; \
        print(numpy.get_include() + "/numpy-py3")') numpy

sed -i "s|Extension('igakit.igalib',|&include_dirs=['./'],|" setup.py

%build
%add_optflags %optflags_shared -fno-strict-aliasing
%python3_build_debug

%install
%python3_install

%check
%__python3 setup.py build_ext -i
export PYTHONPATH=$PWD
%make testall PYTHON=python3

%files
%doc *.rst
%python3_sitelibdir/*


%changelog
