%define _unpackaged_files_terminate_build 1
%define oname isort

%def_with check

Name: python3-module-%oname
Version: 4.3.21
Release: alt1
Summary: Python utility / library to sort Python imports
Group: Development/Python3
License: MIT
Url: https://pypi.org/project/isort
BuildArch: noarch

Source: %oname-%version.tar
Patch0: isort-4.3.21-Skip-tests-which-employ-extra-packages.patch

BuildRequires(pre): rpm-build-python3
%if_with check
BuildRequires: python3(pytest)
BuildRequires: python3(tox)
%endif

%description
Python utility / library to sort Python imports

%prep
%setup -n %oname-%version
%autopatch -p2

%build
%python3_build

%install
%python3_install
mv %buildroot%_bindir/isort{,.py3}

%check
cat > tox.ini <<EOF
[testenv]
commands =
    {envpython} -m pytest test_isort.py {posargs:-vra}
EOF
export PIP_NO_INDEX=YES
export TOXENV=py%{python_version_nodots python3}
tox.py3 --sitepackages -p auto -o -v -- -v

%files
%doc README.rst LICENSE
%_bindir/isort.py3
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version-py3*.egg-info

%changelog
