%define _unpackaged_files_terminate_build 1
%define pypi_name jaraco.context

%def_with check

Name: python3-module-%pypi_name
Version: 5.3.0
Release: alt0.p10.1
Summary: Context managers by Jaraco
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/jaraco.context/
VCS: https://github.com/jaraco/jaraco.context.git
BuildArch: noarch
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Source2: setuptools-68.2.2-py3-none-any.whl
Patch0: %name-%version-alt.patch

%py3_provides %pypi_name
# mapping from PyPI name
Provides: python3-module-%{pep503_name %pypi_name} = %EVR

%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build

%if_with check
%pyproject_builddeps_metadata_extra testing
%endif

%description
%pypi_name provides context managers by Jaraco.

%prep
%setup
%autopatch -p1
%pyproject_scm_init
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%build
# https://bugzilla.altlinux.org/47647
# build with bundled setuptools
mkdir dist
cp %SOURCE2 dist/
echo "$(basename '%SOURCE2')" > dist/.wheeltracker
%pyproject_run -- bash -s <<-'ENDBUILD'
# redefine __python3 to python3 instead of /usr/bin/python3 to point to virt one
%global __python3_orig %__python3
%define __python3 python3
%pyproject_build
%define __python3 %__python3_orig
ENDBUILD

%install
%pyproject_install

%check
%pyproject_run_pytest -vra

%files
%doc README.rst
%python3_sitelibdir/jaraco/__pycache__/context.cpython-*.py*
%python3_sitelibdir/jaraco/context.py
%python3_sitelibdir/%pypi_name-%version.dist-info/

%changelog
