%define _unpackaged_files_terminate_build 1

%define oname kombu

# TODO: fix list issue
%def_disable test
# ModuleNotFoundError: No module named 'sphinx_celery'
%def_without doc

Name: python3-module-%oname
Epoch: 1
Version: 5.0.2
Release: alt1

Group: Development/Python3
License: BSD License
Summary: Kombu is an AMQP messaging framework for Python

URL: https://github.com/celery/kombu/

# https://github.com/celery/kombu.git
# Source-url: https://pypi.io/packages/source/k/%oname/%oname-%version.tar.gz
Source: %name-%version.tar

# Patches from Debian
Patch11: 0001-Remove-image-from-remote-donation-site-privacy-issue.patch

BuildRequires(pre): rpm-build-python3
#BuildRequires: python3-module-docutils python3(sphinx_celery)

BuildRequires: python3-module-setuptools
BuildRequires: python3-module-amqp >= 1:1.4.9
BuildRequires: python3(pytz) python3(case) python3(unittest2) python3(mock) python3(pytest) python3(Pyro4) python3(serpent)
BuildRequires: python3(pytest_cov) python3(redis) python3(msgpack) python3(boto3) python3(pycurl)
BuildRequires: python3-module-tox

%if_with doc
BuildRequires(pre): rpm-macros-sphinx3
BuildRequires: python3-module-sphinx
%endif

%description
AMQP is the Advanced Message Queuing Protocol, an open standard protocol
for message orientation, queuing, routing, reliability and security.

One of the most popular implementations of AMQP is `RabbitMQ`_.

The aim of `Kombu` is to make messaging in Python as easy as possible by
providing an idiomatic high-level interface for the AMQP protocol, and also
provide proven and tested solutions to common messaging problems.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation
BuildArch: noarch

%description docs
AMQP is the Advanced Message Queuing Protocol, an open standard protocol
for message orientation, queuing, routing, reliability and security.

One of the most popular implementations of AMQP is `RabbitMQ`_.

The aim of `Kombu` is to make messaging in Python as easy as possible by
providing an idiomatic high-level interface for the AMQP protocol, and also
provide proven and tested solutions to common messaging problems.

This package contains documentation for %oname.

%prep
%setup
%patch11 -p1

# drop cosmetic only module
subst "s|pytest-sugar||" requirements/test.txt 

%build
%python3_build_debug

%install
%python3_install

%if "%_target_libdir_noarch" != "%_libdir"
mv %buildroot%_target_libdir_noarch %buildroot%_libdir
%endif

%if_with doc
%make -C docs html SPHINXBUILD=sphinx-build-3
%endif

%if_enabled test
%check
python3 setup.py test
%endif

%files
%doc AUTHORS FAQ LICENSE README.rst THANKS TODO
%python3_sitelibdir/kombu*

%if_with doc
%files docs
%doc docs/_build/html/*
%endif

%changelog
