%define _unpackaged_files_terminate_build 1
%define pypi_name python-ldap
%define mname ldap

%def_with check

Name: python3-module-%mname
Version: 3.4.3
Release: alt1

Summary: An object-oriented API to access LDAP directory servers from Python programs
License: Python-style or MIT
Group: Development/Python3
Url: https://www.python-ldap.org
# Source-git: https://github.com/python-ldap/python-ldap

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: libldap-devel
BuildRequires: libsasl2-devel
BuildRequires: libssl-devel

# build backend and its deps
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)

%if_with check
BuildRequires: openldap-servers
BuildRequires: openldap-clients
BuildRequires: python3(pyasn1)
BuildRequires: python3(pyasn1_modules)
%endif

Provides: python3-module-pyldap = %EVR
Obsoletes: python3-module-pyldap < %EVR

%py3_provides %pypi_name

%description
python-ldap provides an object-oriented API to access LDAP
directory servers from Python programs. Mainly it wraps the
OpenLDAP client libs for that purpose.

Additionally the package contains modules for other LDAP-related
stuff (e.g. processing LDIF, LDAPURLs, LDAPv3 sub-schema, etc.).

%prep
%setup

# Fix python interpreter path in Demo directory
grep -rl '^#!/usr/bin/env python' | \
	xargs sed -i '1s|^#!/usr/bin/env python|#!/usr/bin/python3|'

%build
%add_optflags -fno-strict-aliasing
%pyproject_build

%install
%pyproject_install

%check
export BIN="$PATH:%_sbindir"
export TOX_TESTENV_PASSENV=BIN
%tox_check_pyproject

%files
%doc LICENCE CHANGES README TODO Demo
%exclude %python3_sitelibdir/slapdtest
%python3_sitelibdir/_ldap.cpython-*.so
%python3_sitelibdir/ldap
%python3_sitelibdir/ldapurl.py*
%python3_sitelibdir/ldif.py*
%python3_sitelibdir/__pycache__/*
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
