%define oname libacl

Name: python3-module-%oname
Version: 0.5.3
Release: alt2

Summary: POSIX.1e ACLs for python
License: LGPLv2.1+
Group: Development/Python3

URL: http://pylibacl.sourceforge.net/

#Source-url: https://pypi.io/packages/source/p/pylibacl/pylibacl-%version.tar.gz
# Source-git: https://github.com/iustin/pylibacl.git
Source: %name-%version.tar
Patch: libacl-0.5.2-alt-doc.patch

BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-macros-sphinx3
BuildRequires: libacl-devel time python3-module-sphinx

%description
python-libacl is a C extension module for Python which implements
POSIX ACLs manipulation. It is a wrapper on top of the systems's
acl C library - see acl(5).

%prep
%setup
%patch -p1

# Fix shebang
sed -i "s/\(env python\)/\13/" setup.py

%prepare_sphinx3 .
ln -s ../objects.inv doc/

%build
%add_optflags -fno-strict-aliasing
%python3_build_debug

%install
%python3_install

export PYTHONPATH=%buildroot%python3_sitelibdir
%make SPHINXBUILD="sphinx-build-3" doc

%files
%python3_sitelibdir/*
%doc NEWS README doc/html

%changelog
