%define _unpackaged_files_terminate_build 1
%define pypi_name livereload

%def_with check

Name: python3-module-%pypi_name
Version: 2.6.1
Release: alt2
Summary: Utility for starting a server in a directory
License: BSD
Url: https://github.com/lepture/python-livereload
Group: Development/Python3
Source: %name-%version.tar
Patch: %name-%version-alt.patch
BuildArch: noarch

BuildRequires(pre): rpm-build-python3
%if_with check
BuildRequires: python3(nose)
BuildRequires: python3(tornado)
%endif

# we have several versions of Django
# so, we cannot rely on auto-requires
%filter_from_requires /^python3(django\(\..*\)\?)/d

%description
LiveReload provides a command line utility, livereload, for starting
a server in a directory. By default, it will listen to port 35729,
the common port for LiveReload browser extensions. LiveReload is designed
for web developers who know Python.

%prep
%setup
%patch -p1

%build
%python3_build

%install
%python3_install

%check
nosetests3 -s

%files
%doc README.rst CHANGES.rst LICENSE
%_bindir/%pypi_name
%python3_sitelibdir/%pypi_name
%python3_sitelibdir/%pypi_name-%version-py?.?.egg-info

%changelog
