%define oname logtool

%define ver1 0
%define ver2 2
%define ver3 11

Name: python3-module-%oname
Version: %ver1.%ver2.%ver3
Release: alt2

Summary: Methods and tools that assist logging
License: GPLv3+
Group: Development/Python3
Url: https://pypi.python.org/pypi/logtool/
BuildArch: noarch

# https://github.com/clearclaw/logtool.git
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-wrapt
BuildRequires: python-tools-2to3

%py3_provides %oname
%py3_requires wrapt


%description
Methods and tools that assist logging.

%prep
%setup

sed -i 's|#!.*/usr/bin/env python|#!/usr/bin/env python3|' \
    $(find ./ -name '*.py')

sed -i 's|@VERSION@|%version|' %oname/__init__.py
sed -i 's|@V1@|%ver1|' %oname/__init__.py
sed -i 's|@V2@|%ver2|' %oname/__init__.py
sed -i 's|@V3@|%ver3|' %oname/__init__.py

find ./ -type f -name '*.py' -exec 2to3 -w -n '{}' +

%build
%python3_build_debug

%install
%python3_install

%check
%__python3 setup.py test

%files
%doc *.rst
%python3_sitelibdir/*


%changelog
