%define oname meshpy

%def_with python3
%def_without docs

Name: python3-module-%oname
Version: 2018.2.1
Release: alt2
Summary: Triangular and Tetrahedral Mesh Generator in Python
License: MIT
Group: Development/Python3
Url: http://mathema.tician.de/software/meshpy
Packager: Python Development Team <python@packages.altlinux.org>

# http://git.tiker.net/trees/meshpy.git
Source: %oname-%version.tar
# git://github.com/inducer/bpl-subset
Source1: bpl-subset.tar

BuildRequires: gcc-c++
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: boost-python3-devel
BuildRequires: python3-module-pybind11

%if_with docs
BuildRequires: python-module-epydoc python-module-html5lib
%endif

%description
MeshPy offers quality triangular and tetrahedral mesh generation for
Python. Meshes of this type are chiefly used in finite-element
simulation codes, but also have many other applications ranging from
computer graphics to robotics.

%package tests
Summary: Tests for MeshPy
Group: Development/Python3
Requires: %name = %EVR

%description tests
MeshPy offers quality triangular and tetrahedral mesh generation for
Python. Meshes of this type are chiefly used in finite-element
simulation codes, but also have many other applications ranging from
computer graphics to robotics.

This package contains tests for MeshPy.

%package -n python-module-meshpy-docs
Summary: Documentation for MeshPy
Group: Development/Documentation
BuildArch: noarch

%description -n python-module-meshpy-docs
MeshPy offers quality triangular and tetrahedral mesh generation for
Python. Meshes of this type are chiefly used in finite-element
simulation codes, but also have many other applications ranging from
computer graphics to robotics.

This package contains documentation for MeshPy.

%prep
%setup

sed -i 's/python/python3/g' configure.py

rm -fR bpl-subset
tar -xf %SOURCE1

%build
./configure.py
%python3_build_debug

%if_with docs
export PYTHONPATH=$PWD
%make doc
%endif

%install
%python3_install
touch test/__init__.py
rm -f test/clean.sh
cp -fR test %buildroot%python3_sitelibdir/%oname/

%files
%doc LICENSE README.rst
%python3_sitelibdir/*
%exclude %python3_sitelibdir/%oname/test

%files tests
%python3_sitelibdir/%oname/test

%if_with docs
%files -n python-module-meshpy-docs
%doc doc/*.rst
%endif

%changelog
