%define _unpackaged_files_terminate_build 1
%define pypi_name mkdocs

%def_with check

Name: python3-module-%pypi_name
Version: 1.4.0
Release: alt1

Summary: Python tool to create HTML documentation from markdown sources
License: BSD-2-Clause
Group: Development/Python3
Url: https://pypi.org/project/mkdocs/

BuildArch: noarch

Source: %name-%version.tar
Patch0: %name-%version-alt.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: fonts-font-awesome

# build backend and its deps
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)

%if_with check
# install_requires:
BuildRequires: python3(click)
BuildRequires: python3(jinja2)
BuildRequires: python3(markdown)
BuildRequires: python3(yaml)
BuildRequires: python3(watchdog)
BuildRequires: python3-module-ghp-import
BuildRequires: python3(yaml_env_tag)
BuildRequires: python3(packaging)
BuildRequires: python3(mergedeep)
BuildRequires: python3(babel)
%endif

%description
MkDocs is a fast, simple and downright gorgeous static site generator
that's geared towards building project documentation. Documentation
source files are written in Markdown, and configured with a single YAML
configuration file.

%prep
%setup
%autopatch -p1

%build
%pyproject_build

%install
%pyproject_install
rm -r %buildroot%python3_sitelibdir/mkdocs/tests/

# unbundle font-awesome fonts
FONT_AWESOME_FONTS='%_datadir/fonts-font-awesome/fonts'

fonts_bundled=
for f in $(find -P %buildroot%python3_sitelibdir/mkdocs/themes/*/fonts/ -name 'fontawesome-webfont.*' -type f);
do
    printf "Found fontawesome font: '%%s'\n" "$f"
    font_name="$(basename "$f")"
    system_font="$FONT_AWESOME_FONTS/$font_name"
    if [ ! -f "$system_font" ]; then
        # raise to be sure we have synced fonts (bundled vs system)
        printf "Unknown font name: '%%s'\n" "$font_name"
        exit 1
    fi

    ln -sfT "$system_font" "$f"
    fonts_bundled=yes
done
[ "$fonts_bundled" != "yes" ] && exit 1

%check
export TOXENV=py%{python_version_nodots python3}-unittests
%tox_check_pyproject

%files
%_bindir/mkdocs
%python3_sitelibdir/mkdocs/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
