%define oname monascaclient
%def_without check
%def_with docs

Name: python3-module-%oname
Version: 2.7.0
Release: alt1.0.1.p10

Summary: OpenStack Monasca API Client Library

License: Apache-2.0
Group: Development/Python3
Url: https://pypi.org/project/python-monascaclient

Source: %oname-%version.tar
Source1: %oname.watch

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: python3-module-osc-lib >= 1.8.0
BuildRequires: python3-module-oslo.serialization >= 2.18.0
BuildRequires: python3-module-oslo.utils >= 3.33.0
BuildRequires: python3-module-babel >= 2.3.4
BuildRequires: python3-module-iso8601 >= 0.1.11
BuildRequires: python3-module-pbr >= 2.0.0
BuildRequires: python3-module-prettytable >= 0.7.2
BuildRequires: python3-module-yaml >= 3.12

%if_with check
BuildRequires: python3-module-hacking >= 3.0.1 python3-module-hacking < 3.1.0
BuildRequires: python3-module-bandit >= 1.1.0
BuildRequires: python3-module-coverage >= 4.0
BuildRequires: python3-module-oslotest >= 3.2.0
BuildRequires: python3-module-stestr >= 1.0.0
BuildRequires: python3-module-testscenarios >= 0.4
BuildRequires: python3-module-testtools >= 2.2.0
BuildRequires: python3-module-doc8 >= 0.8.1
%endif

%if_with docs
BuildRequires: python3-module-sphinx >= 2.0.0
BuildRequires: python3-module-reno >= 3.1.0
BuildRequires: python3-module-openstackdocstheme >= 2.2.1
%endif

Requires: python3-module-osc-lib >= 1.8.0
Requires: python3-module-oslo.serialization >= 2.18.0
Requires: python3-module-oslo.utils >= 3.33.0
Requires: python3-module-babel >= 2.3.4
Requires: python3-module-iso8601 >= 0.1.11
Requires: python3-module-pbr >= 2.0.0
Requires: python3-module-prettytable >= 0.7.2
Requires: python3-module-yaml >= 3.12

%description
This is a client library for Monasca built to interface with the Monasca API.
It provides a Python API (the monascaclient module) and a command-line tool
(monasca).

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
This package contains tests for %oname.

%if_with docs
%package doc
Summary: Documentation for %oname
Group: Development/Documentation

%description doc
This package contains documentation for %oname.
%endif

%prep
%setup -n %oname-%version

# Remove bundled egg-info
rm -rfv *.egg-info

%build
%pyproject_build

%if_with docs
export PYTHONPATH="$PWD"
# generate html docs
sphinx-build-3 doc/source html
# generate man page
sphinx-build-3 -b man doc/source man
# remove the sphinx-build leftovers
rm -rf html/.{doctrees,buildinfo}
%endif

%install
%pyproject_install

%if_with docs
# install man page
install -pDm 644 man/python-%oname.1 %buildroot%_man1dir/%oname.1
%endif

%check
%__python3 -m stestr run

%files
%doc LICENSE AUTHORS ChangeLog *.rst
%_bindir/monasca
%python3_sitelibdir/%oname
%python3_sitelibdir/python_monascaclient-%version.dist-info
%exclude %python3_sitelibdir/%oname/tests

%files tests
%python3_sitelibdir/%oname/tests

%if_with docs
%files doc
%doc LICENSE *.rst html
%_man1dir/%oname.1.xz
%endif

%changelog
