%define oname neutron-lib
%def_without tests

Name: python3-module-%oname
Version: 3.4.2
Release: alt1.p10
Summary: OpenStack Neutron shared routines and utilities
Group: Development/Python3
License: Apache-2.0
Url: http://docs.openstack.org/developer/%oname
Source: https://tarballs.openstack.org/%oname/%oname-%version.tar.gz

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
BuildRequires: python3-module-wheel
BuildRequires: python3-module-pbr >= 4.0.0
BuildRequires: python3-module-sqlalchemy >= 1.2.0
BuildRequires: python3-module-pecan >= 1.0.0
BuildRequires: python3-module-keystoneauth1 >= 3.14.0
BuildRequires: python3-module-netaddr >= 0.7.18
BuildRequires: python3-module-stevedore >= 1.20.0
BuildRequires: python3-module-os-ken >= 0.3.0
BuildRequires: python3-module-oslo.concurrency >= 3.26.0
BuildRequires: python3-module-oslo.config >= 8.0.0
BuildRequires: python3-module-oslo.context >= 2.22.0
BuildRequires: python3-module-oslo.db >= 4.44.0
BuildRequires: python3-module-oslo.i18n >= 3.20.0
BuildRequires: python3-module-oslo.log >= 4.3.0
BuildRequires: python3-module-oslo.messaging >= 14.2.0
BuildRequires: python3-module-oslo.policy >= 3.6.2
BuildRequires: python3-module-oslo.serialization >= 2.25.0
BuildRequires: python3-module-oslo.service >= 1.24.0
BuildRequires: python3-module-oslo.utils >= 4.5.0
BuildRequires: python3-module-oslo.versionedobjects >= 1.31.2
BuildRequires: python3-module-osprofiler >= 1.4.0
BuildRequires: python3-module-setproctitle >= 1.1.10
BuildRequires: python3-module-webob >= 1.7.1
BuildRequires: python3-module-os-traits >= 0.9.0

# doc
BuildRequires: python3-module-sphinx >= 2.0.0
BuildRequires: python3-module-openstackdocstheme >= 2.2.1
BuildRequires: python3-module-os-api-ref >= 1.4.0
BuildRequires: python3-module-reno >= 3.1.0

%if_with tests
BuildRequires: python3-module-hacking >= 3.0.1 python3-module-hacking < 3.1.0
BuildRequires: python3-module-bandit >= 1.1.0
BuildRequires: python3-module-coverage >= 4.0
BuildRequires: python3-module-ddt >= 1.0.1
BuildRequires: python3-module-fixtures >= 3.0.0
BuildRequires: python3-module-flake8-import-order = 0.12
BuildRequires: python3-module-pylint >= 2.2.0
BuildRequires: python3-module-isort = 4.3.21
BuildRequires: python3-module-subunit >= 1.0.0
BuildRequires: python3-module-oslotest >= 3.2.0
BuildRequires: python3-module-reno >= 3.1.0
BuildRequires: python3-module-stestr >= 1.0.0
BuildRequires: python3-module-testresources >= 2.0.0
BuildRequires: python3-module-testscenarios >= 0.4
BuildRequires: python3-module-testtools >= 2.2.0
%endif

Requires: python3-module-pbr >= 4.0.0
Requires: python3-module-sqlalchemy >= 1.2.0
Requires: python3-module-pecan >= 1.0.0
Requires: python3-module-keystoneauth1 >= 5.1.0 python3-module-keystoneauth1 <= 5.1.2
Requires: python3-module-netaddr >= 0.7.18
Requires: python3-module-stevedore >= 4.1.0 python3-module-stevedore <= 5.0.0
Requires: python3-module-os-ken = 2.6.0
Requires: python3-module-oslo.concurrency >= 5.1.0 python3-module-oslo.concurrency <= 5.1.1
Requires: python3-module-oslo.config >= 9.1.0 python3-module-oslo.config <= 9.1.1
Requires: python3-module-oslo.context >= 5.1.0 python3-module-oslo.context <= 5.1.1
Requires: python3-module-oslo.db >= 12.2.0 python3-module-oslo.db <= 12.3.2
Requires: python3-module-oslo.i18n = 6.0.0
Requires: python3-module-oslo.log >= 5.1.0 python3-module-oslo.log <= 5.2.0
Requires: python3-module-oslo.messaging >= 14.1.0 python3-module-oslo.messaging <= 14.2.2
Requires: python3-module-oslo.policy >= 4.1.0 python3-module-oslo.policy <= 4.1.1
Requires: python3-module-oslo.serialization >= 5.1.0 python3-module-oslo.serialization <= 5.1.1
Requires: python3-module-oslo.service >= 3.1.0 python3-module-oslo.service <= 3.1.1
Requires: python3-module-oslo.utils = 6.1.0
Requires: python3-module-oslo.versionedobjects = 3.1.0
Requires: python3-module-osprofiler >= 1.4.0
Requires: python3-module-setproctitle >= 1.1.10
Requires: python3-module-webob >= 1.7.1
Requires: python3-module-os-traits >= 0.9.0

%description
Neutron-lib is an OpenStack library project used by Neutron, Advanced Services,
and third-party projects to provide common functionality and remove duplication.

%if_with tests
%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
This package contains tests for %oname.
%endif

%package doc
Summary: Documentation for OpenStack Neutron shared routines and utilities
Group: Development/Documentation

%description doc
Documentation for OpenStack Neutron shared routines and utilities

%prep
%setup -n %oname-%version

%build
export PBR_VERSION=%version
%pyproject_build

# generate html docs
python3 setup.py build_sphinx
# remove the sphinx-build leftovers
rm -rf build/sphinx/html/.{doctrees,buildinfo}

%install
%pyproject_install

%files
%doc README.rst
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/tests
%exclude %python3_sitelibdir/neutron_lib/fixture.py

%if_with tests
%files tests
%python3_sitelibdir/*/tests
%python3_sitelibdir/neutron_lib/fixture.py
%endif

%files doc
%doc build/sphinx/html

%changelog
