%define oname novaclient
%def_with check
%def_with docs

Name: python3-module-%oname
Version: 18.3.0
Release: alt0.p10

Summary: Client library for OpenStack Compute API

License: Apache-2.0
Group: Development/Python3
Url: https://pypi.org/project/python-novaclient

Source: %oname-%version.tar
Source1: %oname.watch

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: python3-module-pbr >= 2.0.0
BuildRequires: python3-module-keystoneauth1 >= 3.5.0
BuildRequires: python3-module-iso8601 >= 0.1.11
BuildRequires: python3-module-oslo.i18n >= 3.15.3
BuildRequires: python3-module-oslo.serialization >= 2.18.0
BuildRequires: python3-module-oslo.utils >= 3.33.0
BuildRequires: python3-module-prettytable >= 0.7.2
BuildRequires: python3-module-stevedore >= 2.0.1

%if_with check
BuildRequires(pre): openssl
BuildRequires: python3-module-keystoneclient >= 3.8.0
BuildRequires: python3-module-cinderclient >= 3.3.0
BuildRequires: python3-module-glanceclient >= 2.8.0
BuildRequires: python3-module-neutronclient >= 6.7.0
BuildRequires: python3-module-bandit >= 1.1.0
BuildRequires: python3-module-coverage >= 4.0
BuildRequires: python3-module-ddt >= 1.0.1
BuildRequires: python3-module-fixtures >= 3.0.0
BuildRequires: python3-module-requests-mock >= 1.2.0
BuildRequires: python3-module-openstacksdk >= 0.11.2
BuildRequires: python3-module-stestr >= 2.0.0
BuildRequires: python3-module-testscenarios >= 0.4
BuildRequires: python3-module-testtools >= 2.2.0
BuildRequires: python3-module-tempest >= 17.1.0
BuildRequires: python3-module-iso8601 >= 0.1.11
BuildRequires: python3-module-osprofiler >= 1.4.0
%endif

%if_with docs
BuildRequires: python3-module-sphinx
BuildRequires: python3-module-reno >= 2.5.0
BuildRequires: python3-module-openstackdocstheme >= 1.18.1
BuildRequires: python3-module-sphinxcontrib-apidoc
%endif

Requires: python3-module-pbr >= 2.0.0
Requires: python3-module-keystoneauth1 >= 5.1.0 python3-module-keystoneauth1 <= 5.1.2
Requires: python3-module-iso8601 >= 0.1.11
Requires: python3-module-oslo.i18n = 6.0.0
Requires: python3-module-oslo.serialization >= 5.1.0 python3-module-oslo.serialization <= 5.1.1
Requires: python3-module-oslo.utils = 6.1.0
Requires: python3-module-prettytable >= 0.7.2
Requires: python3-module-stevedore >= 4.1.0 python3-module-stevedore <= 5.0.0

%description
There's a Python API (the novaclient module), and a command-line script (nova).
Each implements 100 percent of the OpenStack Nova API.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
This package contains tests for %oname.

%if_with docs
%package doc
Summary: Documentation for %oname
Group: Development/Documentation

%description doc
This package contains documentation for %oname.
%endif

%prep
%setup -n %oname-%version

# Remove bundled egg-info
rm -rfv *.egg-info

%build
%pyproject_build

%if_with docs
export PYTHONPATH="$PWD"
# generate html docs
sphinx-build-3 doc/source html
# generate man page
sphinx-build-3 -b man doc/source man
# remove the sphinx-build leftovers
rm -rf html/.{doctrees,buildinfo}
%endif

%install
%pyproject_install

%if_with docs
# install man page
install -pDm 644 man/nova.1 %buildroot%_man1dir/%oname.1
%endif

# install bash completion
install -pDm 644 tools/nova.bash_completion \
  %buildroot%_sysconfdir/bash_completion.d/nova.bash_completion

%check
%__python3 -m stestr run

%files
%doc LICENSE AUTHORS ChangeLog *.rst
%_bindir/nova
%python3_sitelibdir/%oname
%python3_sitelibdir/python_novaclient-%version.dist-info
%dir %_sysconfdir/bash_completion.d
%_sysconfdir/bash_completion.d/nova.bash_completion
%exclude %python3_sitelibdir/%oname/tests

%files tests
%python3_sitelibdir/%oname/tests

%if_with docs
%files doc
%doc LICENSE *.rst html
%_man1dir/%oname.1.xz
%endif

%changelog
