%define _unpackaged_files_terminate_build 1

%define mname nss

Name: python3-module-%mname
Version: 1.0.1
Release: alt6

Summary: Python binding for NSS (Network Security Services) and NSPR (Netscape Portable Runtime)
License: MPL-2.0 or GPL-2.0+ or LGPL-2.0+
Group: Development/Python3
Url: http://www.mozilla.org/projects/security/pki/python-nss

# hg clone https://hg.mozilla.org/projects/python-nss
Source: %name-%version.tar
Patch0: 0001-Rename-DSA-RSA-PublicKey-to-Py-DSA-RSA-PublicKey.patch
Patch1: 0002-Fix-python-names-of-RSAPublicKey-DSAPublicKey.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: gcc-c++
BuildRequires: libnss-devel
BuildRequires: libnspr-devel
BuildRequires: python3-module-six
# for tests
BuildRequires: nss-utils

%py3_provides %mname


%description
python-nss is a Python binding for NSS (Network Security Services) and
NSPR (Netscape Portable Runtime). NSS provides cryptography services
supporting SSL, TLS, PKI, PKIX, X509, PKCS*, etc. NSS is an alternative
to OpenSSL and used extensively by major software projects. NSS is
FIPS-140 certified.

NSS is built upon NSPR because NSPR provides an abstraction of common
operating system services, particularly in the areas of networking and
process management. Python also provides an abstraction of common
operating system services but because NSS and NSPR are tightly bound
python-nss exposes elements of NSPR.

%prep
%setup
%autopatch -p2

%build
%add_optflags -fno-strict-aliasing
%python3_build_debug

%install
%python3_install

%check
export PYTHONPATH=%buildroot%python3_sitelibdir
%__python3 test/run_tests -i

%files
%doc LICENSE* README doc/ChangeLog
%python3_sitelibdir/*


%changelog
