%define oname numexpr

Name:           python3-module-%oname
Version:        2.6.2
Release:        alt6
Epoch:          1

Summary:        Fast numerical array expression evaluator for Python and NumPy

Group:          Development/Python3
License:        MIT
URL:            https://github.com/pydata/numexpr

# Source-url: %__pypi_url %oname
Source:         %name-%version.tar
Source1:        site.cfg
Patch1:         %oname-%version-alt-config.patch

BuildRequires(pre): rpm-build-intro >= 2.2.4
BuildRequires(pre): rpm-build-python3
BuildRequires: libnumpy-py3-devel python3-module-numpy-testing

BuildRequires: gcc-c++ liblapack-devel

Requires: /proc

%description
The numexpr package evaluates multiple-operator array expressions many
times faster than NumPy can. It accepts the expression as a string,
analyzes it, rewrites it more efficiently, and compiles it to faster
Python code on the fly. It's the next best thing to writing the
expression in C and compiling it with a specialized just-in-time (JIT)
compiler, i.e. it does not require a compiler at runtime.

Also, numexpr has support for the Intel VML (Vector Math Library) --
integrated in Intel MKL (Math Kernel Library) --, allowing nice
speed-ups when computing transcendental functions (like trigonometrical,
exponentials...) on top of Intel-compatible platforms. This support also
allows to use multiple cores in your computations.

%prep
%setup
%patch1 -p1
# don't require tests from the main module
%__subst "s|from numexpr.tests.*||" numexpr/__init__.py

install -p -m644 %SOURCE1 ./
sed -i 's|@LIBDIR@|%_libdir|' site.cfg
%ifnarch %ix86 x86_64 armh aarch64 ppc64le
sed -i 's@ openblas,@ blas,@' site.cfg
%endif
#find . -type f -name '*.py' -exec 2to3 -w -n '{}' +
sed -i 's|@PYVER@|%_python3_version%_python3_abiflags|' \
	site.cfg

%build
%add_optflags -fno-strict-aliasing
%python3_build_debug

%install
%python3_install
%python3_prune

%check
pushd build/lib.linux*
PYTHONPATH=$(pwd) python3 -c 'import numexpr.tests; numexpr.tests.test()'
popd

%files
%doc *.txt *.rst LICENSES
%python3_sitelibdir/*

%changelog
