%define _unpackaged_files_terminate_build 1
%global oname pathlib2

%def_with check

Name: python3-module-%oname
Version: 2.3.3
Release: alt2

Summary: Object-oriented filesystem paths
License: MIT
Group: Development/Python3

# Source-git: https://github.com/mcmtroffaes/pathlib2
Url: https://pypi.org/project/pathlib2
Source: %name-%version.tar.gz

BuildRequires(pre): rpm-build-python3

%if_with check
BuildRequires: python3-test
BuildRequires: python3(pytest)
BuildRequires: python3(six)
BuildRequires: python3(tox)
%endif

BuildArch: noarch

%global _description \
The old pathlib module on bitbucket is in bugfix-only mode. The goal of\
pathlib2 is to provide a backport of standard pathlib module which tracks\
the standard library module, so all the newest features of the standard\
pathlib can be used also on older Python versions.

%description %_description

%prep
%setup

%build
%python3_build

%install
%python3_install

%check
cat > tox.ini <<EOF
[testenv]
usedevelop=True
commands =
    python -m pytest tests {posargs:-vra}
EOF
export PIP_NO_INDEX=YES
export TOXENV=py3
tox.py3 --sitepackages -vvr -s false

%files
%doc CHANGELOG.rst LICENSE.rst README.rst
%python3_sitelibdir/pathlib2/
%python3_sitelibdir/pathlib2-*.egg-info/

%changelog
