%define _unpackaged_files_terminate_build 1
%define oname pexpect

%def_with check
%def_without doc

Name: python3-module-%oname
Version: 4.8.0
Release: alt3

Summary: Pexpect is a pure Python Expect. It allows easy control of other applications

License: ISC
Group: Development/Python3
Url: https://pypi.python.org/pypi/pexpect

# Source-url: %__pypi_url %oname
Source: %name-%version.tar

Patch: 0003-tests-spawn-python3-not-python.patch

BuildRequires(pre): rpm-build-intro >= 2.2.4
BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-macros-sphinx3
BuildRequires: python3-module-ptyprocess

%if_with doc
BuildRequires: python3-module-sphinx
%endif

%if_with check
BuildRequires: /dev/pts
BuildRequires: man-db
BuildRequires: openssl
BuildRequires: python3-module-pytest
%endif

BuildArch: noarch
Obsoletes: %oname < 0.999-alt6

%description
Pexpect is a pure Python module for spawning child applications; controlling
them; and responding to expected patterns in their output. Pexpect works like
Don Libes' Expect. Pexpect allows your script to spawn a child application and
control it as if a human were typing commands.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation

%description docs
This package contains documentation for %oname.

%prep
%setup
%patch -p1
# fix some incompatibility
%__subst 's|"time"|"time -p true"|' tests/test_async.py
%__subst 's|"python"|"python3"|' pexpect/replwrap.py

fix_env_python () {
    # change shebang /usr/bin/env python -> /usr/bin/$PYTHON
    PYTHON="$1"
    find -type f -name '*.py' | \
        xargs sed -i \
            "1s|#!/usr/bin/env python[[:space:]]*$|#!/usr/bin/$PYTHON|"

    sed -i "1s|#!/usr/bin/env python[[:space:]]*$|#!/usr/bin/$PYTHON|" \
        tests/fakessh/ssh
}

fix_env_python python3

%if_with doc
%prepare_sphinx3 .
ln -s ../objects.inv doc/
%endif

%build
%python3_build

%install
%python3_install
%if_with doc
export PYTHONPATH=%buildroot%python3_sitelibdir
%make -C doc html SPHINXBUILD=sphinx-build-3
%endif

%check
%if_with check
export LC_ALL="en_US.UTF-8"
export PS1="Hello"
py.test3 -v || echo "FIXME: There are IGNORED test failures."
%endif

%files
%doc LICENSE *.rst
%python3_sitelibdir/pexpect/
%python3_sitelibdir/pexpect-*.egg-info/

%if_with doc
%files docs
%doc doc/_build/html
%doc examples
%endif

%changelog
