%define oname pg8000

Name: python3-module-%oname
Version: 1.11.0
Release: alt2

Summary: PostgreSQL interface library
License: BSD
Group: Development/Python3
Url: https://pypi.python.org/pypi/pg8000/
BuildArch: noarch

# https://github.com/mfenniak/pg8000.git
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-nose python3-module-pytz
BuildRequires: python3-module-six

%py3_provides %oname


%description
pg8000 is a Pure-Python interface to the PostgreSQL database engine. It
is one of many PostgreSQL interfaces for the Python programming
language. pg8000 is somewhat distinctive in that it is written entirely
in Python and does not rely on any external libraries (such as a
compiled python module, or PostgreSQL's libpq library). pg8000 supports
the standard Python DB-API version 2.0.

pg8000's name comes from the belief that it is probably about the 8000th
PostgreSQL interface for Python.

%prep
%setup

sed -i 's|#!/usr/bin/env python|#!/usr/bin/env python3|' \
    $(find ./ -name '*.py')

# fix version info
sed -i \
	-e "s/git_refnames\s*=\s*\"[^\"]*\"/git_refnames = \" \(tag: %version\)\"/" \
	%oname/_version.py

%build
%python3_build_debug

%install
%python3_install

%check
%__python3 setup.py test -v

%files
%doc README*
%python3_sitelibdir/*


%changelog
