%define _unpackaged_files_terminate_build 1
%define oname pluggy

%def_with check

Name: python3-module-%oname
Version: 1.0.0
Release: alt1

Summary: Plugin and hook calling mechanisms for python
License: MIT
Group: Development/Python3
# Source-git: https://github.com/pytest-dev/pluggy.git
Url: https://pypi.python.org/pypi/pluggy

BuildArch: noarch

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3(setuptools_scm)

%if_with check
BuildRequires: python3(tox)
BuildRequires: python3(tox_no_deps)
BuildRequires: python3(tox_console_scripts)
%endif

%description
This is the plugin manager as used by pytest but stripped of pytest
specific details.

%prep
%setup

# there is a file with name CHANGELOG.rst, not CHANGELOG
# a wrong reference leads to broken install via pip
sed -i '/^include CHANGELOG$/{s/$/.rst/}' MANIFEST.in

%build
# SETUPTOOLS_SCM_PRETEND_VERSION: when defined and not empty,
# its used as the primary source for the version number in which
# case it will be a unparsed string
export SETUPTOOLS_SCM_PRETEND_VERSION=%version

%python3_build

%install
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%python3_install

%check
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
export PIP_NO_BUILD_ISOLATION=no
export PIP_NO_INDEX=YES
export TOXENV=py3
tox.py3 --sitepackages --no-deps --console-scripts -vvr -s false

%files
%doc LICENSE CHANGELOG.rst README.rst
%python3_sitelibdir/pluggy/
%python3_sitelibdir/pluggy-%version-py%_python3_version.egg-info/

%changelog
