%define oname protobuf3

Name: python3-module-%oname
Epoch: 1
Version: 0.2.1
Release: alt2
Summary: Protocol buffers library for Python 3
License: MIT
Group: Development/Python3
Url: https://pypi.python.org/pypi/protobuf3/

# https://github.com/Pr0Ger/protobuf3.git
Source: %name-%version.tar
Patch1: %oname-%version-alt-docs.patch

BuildArch: noarch

BuildRequires(pre): rpm-build-python3 rpm-macros-sphinx3
BuildRequires: python3-devel python3-module-setuptools
BuildRequires: python3(enum) protobuf-compiler
BuildRequires: python3-module-sphinx-devel
BuildRequires: python3-module-sphinx_rtd_theme
BuildRequires: python3-module-pytest

%py3_provides %oname
%py3_requires enum

%description
Initial idea of this project was lack of support Python 3 in original
Protocol buffers implementation. Currently Google working on this, but
currently there is no easy way to use it with Python 3.

%prep
%setup
%patch1 -p1

%prepare_sphinx3 .
ln -s ../objects.inv docs/

%build
%python3_build_debug

%install
%python3_install

%make -C docs html SPHINXBUILD=py3_sphinx-build

%check
python3 setup.py test
py.test3

%files
%doc *.rst docs/_build/html
%_bindir/*
%python3_sitelibdir/*

%changelog
