%define _unpackaged_files_terminate_build 1

%define pypi_name pyScss
%define norm_name pyscss
%define mod_name %norm_name

%def_with check

Name: python3-module-%pypi_name
Version: 1.4.0
Release: alt4.p10
Summary: pyScss is a compiler for the Sass language
License: MIT
Group: Development/Python
Url: https://pypi.org/project/pyScss
Vcs: https://github.com/Kronuz/pyScss
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch1: %name-%version-alt.patch
Patch2: drop-distutils.patch
%pyproject_runtimedeps_metadata
Requires: python3-module-pillow
BuildRequires(pre): rpm-build-pyproject
BuildRequires: libpcre-devel
%pyproject_builddeps_build
%if_with check
%pyproject_builddeps_metadata
BuildRequires: python3-module-pillow
BuildRequires: python3-module-pytest
%endif

%description
pyScss is a compiler for the Sass language, a superset of CSS3 that adds
programming capabilities and some other syntactic sugar.

%prep
%setup
%patch1 -p1
%patch2 -p1
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

# fix shebangs
grep -sm1 -rl \
    -e '^#!/usr/bin/env python.*$' | \
xargs sed -s -e '1 s/^#!\/usr\/bin\/env python.*$/#!\/usr\/bin\/python3/'

%build
%add_optflags -I%_includedir/pcre -fno-strict-aliasing
%pyproject_build

%install
%pyproject_install
install -p -m644 scss/grammar/*.g \
	%buildroot%python3_sitelibdir/scss/grammar/

pushd %buildroot%_bindir
for i in $(ls); do
	mv $i $i.py3
done
popd

%check
%pyproject_run_pytest -ra -Wignore

%files
%doc README.*
%_bindir/less2scss.py3
%_bindir/pyscss.py3
%dir %python3_sitelibdir/scss
%python3_sitelibdir/scss/*.py
%python3_sitelibdir/scss/__pycache__/
%dir %python3_sitelibdir/scss/grammar
%python3_sitelibdir/scss/grammar/*.py
%python3_sitelibdir/scss/grammar/*.g
%python3_sitelibdir/scss/grammar/_scanner.*.so
%python3_sitelibdir/scss/grammar/__pycache__/
%python3_sitelibdir/scss/extension/
%python3_sitelibdir/%pypi_name-%version.dist-info/

%changelog
