%define _unpackaged_files_terminate_build 1
%define mname pyasn1

%def_with check

Name: python3-module-%mname
Version: 0.4.8
Release: alt2

Summary: Abstract Syntax Notation One (ASN.1), Python implementation
License: BSD
Group: Development/Python3
# Source-git: https://github.com/etingof/pyasn1.git
Url: https://pypi.python.org/pypi/pyasn1

Source0: %name-%version.tar
Source1: pyasn1.watch
Patch: %name-%version-alt.patch

BuildRequires(pre): rpm-build-python3

%if_with check
BuildRequires: python3(pytest)
BuildRequires: python3(tox)
%endif

BuildArch: noarch

%description
This is an implementation of ASN.1 types and codecs in Python programming
language. It has been first written to support particular protocol (SNMP)
but then generalized to be suitable for a wide range of protocols
based on ASN.1 specification.

%prep
%setup
%patch -p1

%build
%python3_build

%install
%python3_install

%check
cat > tox.ini <<EOF
[testenv]
commands =
    {envpython} -m pytest {posargs:-vra}
EOF
export PIP_NO_INDEX=YES
export TOXENV=py3
tox.py3 --sitepackages -vvr -s false

%files
%doc LICENSE.rst README.md CHANGES.rst
%python3_sitelibdir/pyasn1/
%python3_sitelibdir/pyasn1-%version-*.egg-info/

%changelog
