%define module_name pygraphviz

Name: python3-module-%module_name
Version: 1.7
Release: alt1

Summary: Python wrapper for the Graphviz Agraph data structure

License: BSD
Group: Development/Python3
Url: https://pygraphviz.github.io/

Packager: Denis Klimov <zver@altlinux.org>

# https://github.com/pygraphviz/pygraphviz.git
Source: %module_name-%version.tar

BuildRequires: libgraphviz-devel

BuildRequires(pre): rpm-build-intro >= 2.2.4
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-distribute

%description
Python wrapper for the Graphviz Agraph data structure.
It can be used to create and draw networks and graphs with Graphviz.

%prep
%setup -n %module_name-%version

%build
%add_optflags -I%_includedir/graphviz

%python3_build_debug

%install
%python3_install
%python3_prune
%__subst "s|from pygraphviz.tests.test import run as test||" %buildroot%python3_sitelibdir/pygraphviz/__init__.py

%files
%doc %_docdir/*
%python3_sitelibdir/pygraphviz/
%python3_sitelibdir/pygraphviz-*.egg-info

%changelog
