%define _unpackaged_files_terminate_build 1
%define oname pylint

%def_with check

Name: python3-module-%oname
Version: 2.8.2
Release: alt2

Summary: Python code static checker
License: GPLv2+
Group: Development/Python3
# https://github.com/PyCQA/pylint.git
Url: http://www.pylint.org/

Source: %name-%version.tar
Patch0: %name-%version-alt.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-pytest-runner
BuildRequires: python3(setuptools_scm)

%if_with check
BuildRequires: python3(lazy-object-proxy)
BuildRequires: python3(pytest)
BuildRequires: python3(astroid)
BuildRequires: python3(mccabe)
BuildRequires: python3(isort)
BuildRequires: python3(enchant)
BuildRequires: python3(tox)
BuildRequires: python3(tox_console_scripts)
BuildRequires: python3(tox_no_deps)
BuildRequires: python3(turtle)
BuildRequires: hunspell-en
%endif

BuildArch: noarch
Provides: pylint-py3 = %EVR
Obsoletes: pylint-py3 < %EVR
%py3_requires isort
%py3_requires mccabe

%description
Pylint is a Python source code analyzer which looks for programming
errors, helps enforcing a coding standard and sniffs for some code
smells (as defined in Martin Fowler's Refactoring book)

Pylint can be seen as another PyChecker since nearly all tests you
can do with PyChecker can also be done with Pylint. However, Pylint
offers some more features, like checking length of lines of code,
checking if variable names are well-formed according to your coding
standard, or checking if declared interfaces are truly implemented,
and much more.

Additionally, it is possible to write plugins to add your own checks.

%prep
%setup
%autopatch -p1

%build
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%python3_build

%install
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%python3_install
# do not pack tests
rm -r %buildroot%python3_sitelibdir/pylint/test*

pushd %buildroot%_bindir
for i in $(ls); do
       mv $i $i.py3
done

%check
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
export PIP_NO_INDEX=YES
export TOXENV=py3
tox.py3 --sitepackages --console-scripts -vvr --no-deps -- \
    -v --ignore tests/benchmark/test_baseline_benchmarks.py

%files
%doc ChangeLog README.rst
%_bindir/pylint.py3
%_bindir/epylint.py3
%_bindir/pyreverse.py3
%_bindir/symilar.py3
%python3_sitelibdir/pylint/
%python3_sitelibdir/pylint-*.egg-info/

%changelog
